/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import net.skinsrestorer.api.bukkit.events.SkinApplyBukkitEvent;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.api.serverinfo.ServerVersion;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.skinrefresher.MappingSpigotSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.PaperSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.SpigotSkinRefresher;
import net.skinsrestorer.bukkit.utils.BukkitPropertyApplier;
import net.skinsrestorer.bukkit.utils.NoMappingException;
import net.skinsrestorer.shadow.paperlib.PaperLib;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.utils.log.SRLogLevel;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.spigot.SpigotPassengerUtil;
import net.skinsrestorer.spigot.SpigotUtil;
import net.skinsrestorer.v1_7.BukkitLegacyPropertyApplier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SkinApplierBukkit {
    private final SkinsRestorer plugin;
    private final SRLogger log;
    private final Consumer<Player> refresh;
    private boolean optFileChecked;
    private boolean disableDismountPlayer;
    private boolean disableRemountPlayer;
    private boolean enableDismountEntities;

    public SkinApplierBukkit(SkinsRestorer plugin, SRLogger log) throws InitializeException {
        this.plugin = plugin;
        this.log = log;
        this.refresh = this.detectRefresh();
    }

    private Consumer<Player> detectRefresh() throws InitializeException {
        if (this.isPaper()) {
            boolean protocolSupportExists;
            boolean viaVersionExists = this.plugin.getServer().getPluginManager().getPlugin("ViaVersion") != null;
            boolean bl = protocolSupportExists = this.plugin.getServer().getPluginManager().getPlugin("ProtocolSupport") != null;
            if (viaVersionExists || protocolSupportExists) {
                this.log.debug(SRLogLevel.WARNING, "Unsupported plugin (ViaVersion or ProtocolSupport) detected, forcing SpigotSkinRefresher");
                return this.selectSpigotRefresher();
            }
            try {
                return new PaperSkinRefresher(this.log);
            }
            catch (NoMappingException e) {
                throw e;
            }
            catch (InitializeException e) {
                this.log.severe("PaperSkinRefresher failed! (Are you using hybrid software?) Only limited support can be provided. Falling back to SpigotSkinRefresher.");
            }
        }
        return this.selectSpigotRefresher();
    }

    private Consumer<Player> selectSpigotRefresher() throws InitializeException {
        if (ReflectionUtil.SERVER_VERSION.isNewer(new ServerVersion(1, 17, 1))) {
            return new MappingSpigotSkinRefresher(this.plugin, this.log);
        }
        return new SpigotSkinRefresher(this.plugin, this.log);
    }

    protected void applySkin(Player player, IProperty property) {
        if (!player.isOnline()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            SkinApplyBukkitEvent applyEvent = new SkinApplyBukkitEvent(player, property);
            Bukkit.getPluginManager().callEvent((Event)applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            IProperty eventProperty = applyEvent.getProperty();
            if (eventProperty == null) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.applyProperty(player, eventProperty);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.updateSkin(player));
            });
        });
    }

    public void applyProperty(Player player, IProperty property) {
        if (ReflectionUtil.classExists("com.mojang.authlib.GameProfile")) {
            BukkitPropertyApplier.applyProperty(player, property);
        } else {
            BukkitLegacyPropertyApplier.applyProperty(player, property);
        }
    }

    public Map<String, Collection<IProperty>> getPlayerProperties(Player player) throws ReflectionException {
        if (ReflectionUtil.classExists("com.mojang.authlib.GameProfile")) {
            return BukkitPropertyApplier.getPlayerProperties(player);
        }
        return BukkitLegacyPropertyApplier.getPlayerProperties(player);
    }

    public void updateSkin(Player player) {
        if (!player.isOnline()) {
            return;
        }
        if (!this.optFileChecked) {
            this.checkOptFile();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (PaperLib.isSpigot() && SpigotUtil.hasPassengerMethods()) {
                Entity vehicle = player.getVehicle();
                SpigotPassengerUtil.refreshPassengers(this.plugin, player, vehicle, this.disableDismountPlayer, this.disableRemountPlayer, this.enableDismountEntities);
            }
            for (Player ps : Bukkit.getOnlinePlayers()) {
                try {
                    ps.hidePlayer((Plugin)this.plugin, player);
                }
                catch (NoSuchMethodError ignored) {
                    ps.hidePlayer(player);
                }
                try {
                    ps.showPlayer((Plugin)this.plugin, player);
                }
                catch (NoSuchMethodError ignored) {
                    ps.showPlayer(player);
                }
            }
            this.refresh.accept(player);
        });
    }

    private void checkOptFile() {
        Path fileDisableDismountPlayer = this.plugin.getDataFolderPath().resolve("disablesdismountplayer");
        Path fileDisableRemountPlayer = this.plugin.getDataFolderPath().resolve("disablesremountplayer");
        Path fileEnableDismountEntities = this.plugin.getDataFolderPath().resolve("enablesdismountentities");
        Path fileTxtDisableDismountPlayer = this.plugin.getDataFolderPath().resolve("disableDismountPlayer.txt");
        Path fileTxtDisableRemountPlayer = this.plugin.getDataFolderPath().resolve("disableRemountPlayer.txt");
        Path fileTxtEnableDismountEntities = this.plugin.getDataFolderPath().resolve("enableDismountEntities.txt");
        this.disableDismountPlayer = Files.exists(fileTxtDisableDismountPlayer, new LinkOption[0]) || Files.exists(fileDisableDismountPlayer, new LinkOption[0]);
        this.disableRemountPlayer = Files.exists(fileTxtDisableRemountPlayer, new LinkOption[0]) || Files.exists(fileDisableRemountPlayer, new LinkOption[0]);
        this.enableDismountEntities = Files.exists(fileTxtEnableDismountEntities, new LinkOption[0]) || Files.exists(fileEnableDismountEntities, new LinkOption[0]);
        this.log.debug("[Debug] Opt Files: { disableDismountPlayer: " + this.disableDismountPlayer + ", disableRemountPlayer: " + this.disableRemountPlayer + ", enableDismountEntities: " + this.enableDismountEntities + " }");
        this.optFileChecked = true;
    }

    private boolean isPaper() {
        if (PaperLib.isPaper() && ReflectionUtil.SERVER_VERSION.isNewer(new ServerVersion(1, 11, 2))) {
            if (this.hasPaperMethods()) {
                return true;
            }
            this.log.debug(SRLogLevel.WARNING, "Paper detected, but the methods are missing. Disabling Paper Refresher.");
            return false;
        }
        return false;
    }

    private boolean hasPaperMethods() {
        try {
            ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    public SkinApplierBukkit(SkinsRestorer plugin, SRLogger log, Consumer<Player> refresh) {
        this.plugin = plugin;
        this.log = log;
        this.refresh = refresh;
    }

    public Consumer<Player> getRefresh() {
        return this.refresh;
    }

    public void setOptFileChecked(boolean optFileChecked) {
        this.optFileChecked = optFileChecked;
    }
}

